IF  EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[P_TRILHO_PROD_NECESSIDADE_FORN]') AND TYPE IN (N'P', N'PC'))
	DROP PROCEDURE [DBO].[P_TRILHO_PROD_NECESSIDADE_FORN] 

GO
--EXECUTE P_TRILHO_PROD_NECESSIDADE_FORN 1,1,5

 --> EXECUTE P_TRILHO_PROD_NECESSIDADE_FORN 1,1,7
 
 --EXECUTE P_TRILHO_PROD_NECESSIDADE_FORN 1,1,5

CREATE PROCEDURE [DBO].[P_TRILHO_PROD_NECESSIDADE_FORN] (@CD_EMP INT = 1, @CD_CTR_DEPO INT=1, @CD_MAQ INT=1) 
WITH ENCRYPTION AS

SET NOCOUNT ON;
	Print 'Gerando trilhos fornecedor da maquina ' + convert(varchar, @CD_MAQ)
	DECLARE @DIAS_INFERIOR_ENTRADA INT;
	DECLARE @FLAG_SOMENTE_PRODUTOS_COM_LOTE INT;
	DECLARE @FLAG_SOMENTE_PRODUTOS_SEM_QUEMB INT;

	--VARIÁVEIS UTILIZADAS NO CURSOR DE NECESSIDADE
	DECLARE @DT_MOV DATETIME;
	DECLARE @CD_FILIAL INT;
	DECLARE @CD_FORN INT;
	DECLARE @CD_PROD INT; 
	DECLARE @EXCESSO MONEY;
	DECLARE @VLR_CUSTO MONEY;
	DECLARE @QT_EMB_COMPRA MONEY;

	--VARIÁVEIS PARA O CURSOR DAS NOTAS
	DECLARE @CD_NF INT;
	DECLARE @NECESSIDADE_FORN MONEY; 
	DECLARE @QTDE_ENVIAR MONEY;

	--VARIÁVEIS AUXILIARES
	DECLARE @CD_PROD_ATUAL INT; 
	DECLARE @EXCESSO_ATUAL MONEY;

	

	DELETE FROM 
		TRILHO_PROD_NECESSIDADE_FORN
	WHERE
		CD_EMP = @CD_EMP
		AND CD_EXCESSO_MAQ = @CD_MAQ 
		AND CD_CTR_DEPO = @CD_CTR_DEPO;
	
	CREATE TABLE #TMPNECESSIDADE (DT_MOV		DATETIME,
									CD_FILIAL	INT,  
									CD_NF		INT,
									CD_FORN		INT,
									CD_PROD		INT, 
									EXCESSO		MONEY,
									NECESSIDADE	MONEY,
									VLR_CUSTO	MONEY)

	--PARAMETROS DE LOTE E DIAS DE ENTRADA
	SELECT 
		@DIAS_INFERIOR_ENTRADA = DIAS_INFERIOR_ENTRADA, 
		@FLAG_SOMENTE_PRODUTOS_COM_LOTE =  FLAG_SOMENTE_PRODUTOS_COM_LOTE,
		@FLAG_SOMENTE_PRODUTOS_SEM_QUEMB = FLAG_SOMENTE_PRODUTOS_SEM_QUEMB
	FROM 
		EST_EXCESSO_MAQ 
	WHERE 
		CD_EMP = @CD_EMP 
		AND CD_EXCESSO_MAQ = @CD_MAQ;



	DECLARE 
		_CURSOR_NECESSIDADE 
	CURSOR FOR
	SELECT DISTINCT
		E.DT_MOV,
		E.CD_FILIAL,
		F.CD_FORN,
		E.CD_PROD,
		E.EXCESSO,
		E.VLR_CUSTO,
		(C.APRES_QT_CP * C.APRES_EMB_CP) QT_EMB_COMPRA
	FROM        
		TRILHO_MAQ_EXCESSO E
		INNER JOIN EST_EXCESSO_MAQ_TRILHO TR ON 
			E.CD_EMP			=TR.CD_EMP AND
			E.CD_EXCESSO_MAQ	=TR.CD_EXCESSO_MAQ

		INNER JOIN TRILHO T ON 
			TR.CD_EMP	 = T.CD_EMP AND
			TR.CD_TRILHO = T.CD_TRILHO
		
		INNER JOIN TRILHO_PRC_FILIAL tf ON 
			T.CD_EMP	 = Tf.CD_EMP AND
			T.CD_TRILHO  = Tf.CD_TRILHO
			 	 and e.cd_filial = tf.cd_filial

		LEFT JOIN EST_PROD_TRILHO_EXCESSO_PENDENTE P ON 
			E.CD_EMP	 = P.CD_EMP AND
			E.CD_FILIAL = P.CD_FILIAL

		INNER JOIN ( SELECT 
							CD_FORN 
						FROM 
							PG_FORN
						UNION 
						SELECT 
							CD_FORN_VINCULADO
						FROM 
							V_PG_FORN_VINCULADO ) F ON 
						T.CD_FORN = F.CD_FORN
		JOIN EST_PROD_FORN C ON 
		E.CD_EMP  =	C.CD_EMP AND
		F.CD_FORN = C.CD_FORN AND
		E.CD_PROD = C.CD_PROD 
	WHERE
		E.CD_EMP = 1
		AND P.CD_EMP IS NULL --NAO GERAR SE TIVER TRILHO PENDENTE..(SOL. CRIS NUNES)
		AND E.DT_MOV = DBO.F_HOJE()
		AND E.CD_EXCESSO_MAQ = @CD_MAQ
		AND E.CD_CTR_DEPO = @CD_CTR_DEPO

	ORDER BY
		E.CD_FILIAL,
		E.EXCESSO DESC,
		E.CD_PROD,
		F.CD_FORN
		
	OPEN _CURSOR_NECESSIDADE

	FETCH NEXT FROM _CURSOR_NECESSIDADE INTO @DT_MOV, @CD_FILIAL, @CD_FORN, @CD_PROD, @EXCESSO, @VLR_CUSTO, @QT_EMB_COMPRA;

	WHILE @@FETCH_STATUS <> -1
	BEGIN

		SET @EXCESSO_ATUAL = @EXCESSO;

		DECLARE 
			_CURSOR_NOTAS 
		CURSOR FOR
		SELECT 
			EN.CD_NF,
			SUM(ROUND((D.QT_SLD_IT / @QT_EMB_COMPRA), 0) * @QT_EMB_COMPRA) AS NECESSIDADE_FORN
		FROM 
			EST_NF_ENT EN  
						
			INNER JOIN EST_NF_ENT_IT I ON 
				EN.CD_EMP	 = I.CD_EMP AND
				EN.CD_FILIAL = I.CD_FILIAL AND
				EN.CD_NF	 = I.CD_NF AND
				EN.DT_ENT	 = I.DT_ENT 

			LEFT JOIN ( SELECT
							CD_EMP,
							CD_FILIAL,
							CD_NF,
							CD_PROD,
							SUM(QTDE_PROD) AS QTDE_PROD
						FROM
							EST_NF_ENT_IT_EST_PROD_CPL_LOTE 
						GROUP BY
							CD_EMP,
							CD_FILIAL,
							CD_NF,
							CD_PROD) LOTE ON
						I.CD_EMP = LOTE.CD_EMP
						AND I.CD_FILIAL = LOTE.CD_FILIAL
						AND I.CD_NF = LOTE.CD_NF
						AND I.CD_PROD = LOTE.CD_PROD 
			--APENAS NOTAS COM VALIDACAO ELETRONICA
			INNER JOIN V_EST_NF_ENT_NFE NFE ON 
				EN.CD_EMP	 = NFE.CD_EMP AND
				EN.CD_FILIAL = NFE.CD_FILIAL AND
				EN.CD_NF	 = NFE.CD_NF
						 
			INNER JOIN V_EST_NF_ENT_IT_DEV_SLD D ON 
				I.CD_EMP	= D.CD_EMP AND
				I.CD_FILIAL = D.CD_FILIAL AND
				I.CD_NF		= D.CD_NF AND
				I.CD_PROD   = D.CD_PROD

			INNER JOIN GLB_MOV_OP O ON 
				EN.CD_NT_MOV = O.CD_MOV_OP 
				AND O.TP_MOV IN (0) -- VAI DEVOLVER BONIFICACAO?? 
		WHERE
			EN.STS_NF = 0
			AND D.QT_SLD_IT > 0
			AND I.CD_EMP=1
			AND I.DT_ENT> '20160101'
			AND EN.CD_FILIAL = @CD_FILIAL
			AND EN.CD_FORN = @CD_FORN
			AND I.CD_PROD = @CD_PROD

			--SOMENTE PRODUTOS COM CAIXARIA
			AND ROUND((D.QT_SLD_IT / @QT_EMB_COMPRA), 0, 1) * @QT_EMB_COMPRA > 0

			--LIITANDO A DATA DE ENTRADA DA NOTA FISCAL, CASO ESTEJA PARAMETRIZADO NA MÁQUINA DO TRILHO
			AND EN.DT_ENT >= CASE WHEN @DIAS_INFERIOR_ENTRADA > 0 THEN DATEADD(DAY, @DIAS_INFERIOR_ENTRADA * -1, CONVERT(VARCHAR(10), GETDATE(), 102))
								ELSE EN.DT_ENT END

			--RESTRINGINDO SOMENTE OS PRODUTOS QUE POSSUAM LOTE, CASO ESTEJA PARAMETRIZADO NA MÁQUINA DO TRILHO
			AND COALESCE(LOTE.CD_EMP,0) = CASE WHEN @FLAG_SOMENTE_PRODUTOS_COM_LOTE = 1 THEN @CD_EMP ELSE COALESCE(LOTE.CD_EMP,0) END

			--RETRINGINDO SOMENTE OS PRODUTOS QUE NÃO POSSUEM CAIXARIA
			AND @QT_EMB_COMPRA = CASE WHEN @FLAG_SOMENTE_PRODUTOS_SEM_QUEMB = 1 THEN 1 ELSE @QT_EMB_COMPRA END

		GROUP BY	
			EN.CD_EMP, 
			EN.CD_FILIAL,
			EN.CD_NF,
			EN.CD_FORN,  
			I.CD_PROD,
			EN.DT_ENT 
		ORDER BY
			EN.DT_ENT DESC;

		OPEN _CURSOR_NOTAS;

		FETCH NEXT FROM _CURSOR_NOTAS INTO @CD_NF, @NECESSIDADE_FORN 

		WHILE @@FETCH_STATUS <> -1 AND @EXCESSO_ATUAL > 0
		BEGIN
			
			SET @QTDE_ENVIAR = CASE WHEN @NECESSIDADE_FORN > @EXCESSO_ATUAL THEN @EXCESSO_ATUAL ELSE @NECESSIDADE_FORN END
			SET @QTDE_ENVIAR = ROUND((@QTDE_ENVIAR / @QT_EMB_COMPRA), 0, 1) * @QT_EMB_COMPRA

			PRINT 'FILIAL: ' + CAST(@CD_FILIAL AS VARCHAR) + ' - FORNECEDOR: ' + CAST(@CD_FORN AS VARCHAR) + ' CD_NOTA: ' + CAST(@CD_NF AS VARCHAR)  + ' - PRODUTO: ' + CAST(@CD_PROD AS VARCHAR) + ' - QTDE: ' + CAST(@QTDE_ENVIAR AS VARCHAR);
			PRINT 'EXCESSO_ATUAL: ' + CAST(@EXCESSO_ATUAL AS VARCHAR) + ' - NECESSIDADE_FORN: ' + CAST(@NECESSIDADE_FORN AS VARCHAR);

			IF @QTDE_ENVIAR > 0
			BEGIN
				INSERT INTO
					#TMPNECESSIDADE (DT_MOV, CD_FILIAL, CD_NF, CD_FORN, CD_PROD, EXCESSO, NECESSIDADE, VLR_CUSTO)
				VALUES
					(@DT_MOV, @CD_FILIAL, @CD_NF, @CD_FORN, @CD_PROD, @EXCESSO, @QTDE_ENVIAR, @VLR_CUSTO);
				PRINT 'Atualizei tabela de necessidades'
				SET @EXCESSO_ATUAL = @EXCESSO_ATUAL - @QTDE_ENVIAR;
			END

			FETCH NEXT FROM _CURSOR_NOTAS INTO @CD_NF, @NECESSIDADE_FORN
		END

		PRINT 'Saiu do cursor _CURSOR_NOTAS'
		CLOSE _CURSOR_NOTAS;
		DEALLOCATE _CURSOR_NOTAS;

		FETCH NEXT FROM _CURSOR_NECESSIDADE INTO @DT_MOV, @CD_FILIAL, @CD_FORN, @CD_PROD, @EXCESSO, @VLR_CUSTO,@QT_EMB_COMPRA;
	END

	--FECHANDO O CURSOR
	CLOSE _CURSOR_NECESSIDADE;
	DEALLOCATE _CURSOR_NECESSIDADE;

	DELETE FROM #TMPNECESSIDADE WHERE NECESSIDADE < 1 ;


	INSERT INTO 
		TRILHO_PROD_NECESSIDADE_FORN (DT_MOV, CD_EMP, CD_CTR_DEPO, CD_FILIAL, CD_EXCESSO_MAQ, CD_FORN, CD_PROD, EXCESSO, NECESSIDADE, VLR_CUSTO)  
	SELECT 
		DT_MOV, 
		@CD_EMP CD_EMP, 
		@CD_CTR_DEPO CD_CTR_DEPO, 
		CD_FILIAL,
		@CD_MAQ CD_EXCESSO_MAQ, 
		CD_FORN, 
		CD_PROD,  
		MAX(EXCESSO),
		SUM(NECESSIDADE),
		AVG(VLR_CUSTO)
	FROM 
		#TMPNECESSIDADE
	GROUP BY 
		DT_MOV, 
		CD_FILIAL,
		CD_FORN, 
		CD_PROD;
		 
	INSERT INTO TRILHO_PROD_NECESSIDADE_FORN_EST_NF_ENT (CD_CTR, CD_NF, QT_IT)  
	SELECT 
		 T.CD_CTR, 
		 N.CD_NF,
		 N.NECESSIDADE QT_IT
	FROM 
		TRILHO_PROD_NECESSIDADE_FORN T
		INNER JOIN #TMPNECESSIDADE N ON 
			T.DT_MOV		= N.DT_MOV AND
			T.CD_FILIAL		= N.CD_FILIAL AND
			T.CD_FORN		= N.CD_FORN AND 
			T.CD_PROD		= N.CD_PROD  
	WHERE
		T.CD_EMP =@CD_EMP
		AND T.CD_CTR_DEPO =@CD_CTR_DEPO
		AND T.CD_EXCESSO_MAQ=@CD_MAQ;
 
GO
